package com.zjty.tynotes.weekly.subject.controller;

import com.zjty.tynotes.misc.config.AutoDocument;
import com.zjty.tynotes.pas.entity.User;
import com.zjty.tynotes.pas.entity.vo.PageRequest;
import com.zjty.tynotes.weekly.subject.service.UserManageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import static org.springframework.http.ResponseEntity.ok;

/**
 * @Author gwj
 * @create 2020/3/2 13:04
 */
@Api(tags = "人员管理模块", protocols = "http")
@RestController
@RequestMapping("/manage/user")
@AutoDocument
public class UserManageController {
    @Autowired
    private UserManageService userManageService;


    @ApiOperation(value = "根据id查询用户", response = User.class)
    @GetMapping("/findUser/{id}")
    public ResponseEntity findUser(@RequestBody @Valid String id) {
        return ok(userManageService.findUserById(id));
    }

    //待完成
    @ApiOperation(value = "查询人员列表", response = User.class)
    @GetMapping("/findUserList/{id}")
    public ResponseEntity findUserList(@RequestBody PageRequest pageRequest) {
        return ok(userManageService.findUserList(pageRequest));
    }

    @ApiOperation(value = "根据权限查询可查看部门列表", response = User.class)
    @GetMapping("/findDepartmentList/{id}")
    public ResponseEntity findDepartmentList(@PathVariable("id") String id) {
        return ok(userManageService.findDepartmentList(id));
    }

//    @ApiOperation(value = "查询人员任务详情", response = User.class)
//    @GetMapping("/findUserWork/{id}/{status}")
//    public ResponseEntity findUserWork(@PathVariable("id") String id,
//                                             @PathVariable("status") String status) {
//        return ok(userManageService.findUserWork(id,status));
//    }

    @ApiOperation(value = "更新当前用户自身信息")
    @PutMapping("/updateSelf")
    public ResponseEntity updateSelf(@RequestBody @NotNull User user){
        User userById = userManageService.findUserById(user.getId());
        boolean b = userManageService.updateSelf(user,userById);
        if(b){
            return ok("更改密码成功");
        }
        return ok("更改密码失败");
    }

    @ApiOperation(value = "更新当前用户密码")
    @PutMapping("/password")
    public ResponseEntity updatePassword(@RequestBody @NotNull User user){
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        User principal = (User) authentication.getPrincipal();
        User userByUsername = userManageService.findfindUserByUsername(principal.getUsername());
        userByUsername.setPassword(user.getPassword());
        boolean b = userManageService.updatePas(userByUsername);
        if(b){
            return ok("更改密码成功");
        }
        return ok("更改密码失败");
    }

}
