package com.zjty.tynotes.pas.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import javax.validation.constraints.NotNull;

/**
 * @Author gwj
 * @create 2020/2/28 14:11
 * @des 用户角色关联类
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "用户角色关联", description = "用户角色关联")
@Document(collection = "pas_user_role")
public class UserRole {
    @Id
    @ApiModelProperty(value = "id",example = "1")
    private String id;

    @NotNull(message = "用户id不可为空")
    @ApiModelProperty(value = "用户id",example = "1")
    private String userId;

    @NotNull(message = "角色id不可为空")
    @ApiModelProperty(value = "角色id",example = "1")
    private String roleId;
}
