package com.zjty.tynotes.pas.controller;

import com.zjty.tynotes.misc.config.AutoDocument;
import com.zjty.tynotes.pas.dao.AuthorityDao;
import com.zjty.tynotes.pas.dao.DayDao;
import com.zjty.tynotes.pas.dao.RoleAuthorityDao;
import com.zjty.tynotes.pas.dao.RoleDao;
import com.zjty.tynotes.pas.entity.Authority;
import com.zjty.tynotes.pas.entity.Day;
import com.zjty.tynotes.pas.entity.Role;
import com.zjty.tynotes.pas.entity.RoleAuthority;
import com.zjty.tynotes.pas.entity.vo.JobLeads;
import com.zjty.tynotes.pas.service.IUserService;
import com.zjty.tynotes.pas.service.impl.UserServiceImpl;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Author gwj
 * @create 2020/4/1 10:56
 */
@Api(tags = "用户管理权限管理模块", protocols = "http")
@RestController
@RequestMapping("/pas/user")
@AutoDocument
public class TestController {
    @Autowired
    private DayDao dayDao;
    @Autowired
    private AuthorityDao authorityDao;
    @Autowired
    private RoleDao roleDao;
    @Autowired
    private RoleAuthorityDao roleAuthorityDao;
    @Autowired
    private UserServiceImpl userService;

//    @GetMapping("/test")
//    public void calculate() throws Exception{
//        Calendar calendar = Calendar.getInstance();
//        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
//        String format = sdf.format(new Date());
//        Date parse = sdf.parse(format);
//        //计算这个月的应出勤天数
//        calendar.set(Calendar.DAY_OF_MONTH,1);
//        Date startTime = calendar.getTime();
//        calendar.add(Calendar.MONTH,1);
//        calendar.set(Calendar.DAY_OF_MONTH,1);
//        Date endTime = calendar.getTime();
//        List<Day> days = dayDao.findAllByStatusAndDateBetween("0", startTime, endTime);
//        if(days!=null){
//            System.out.println(days.size());
//        }
//    }

    @GetMapping("/test")
    public void addAuthority() throws Exception{
        List<String> authorityName = new ArrayList<>();
        authorityName.add("用户管理");
        authorityName.add("权限管理");
        authorityName.add("部门管理");
        authorityName.add("考勤管理");
        authorityName.add("角色管理");

        List<Authority> authorities = authorityDao.findAllByNameIn(authorityName);
        Optional<Role> optional = roleDao.findById("5e82c9d8e02f2a779aa76993");
        if(optional.isPresent()){
            Role role = optional.get();
            List<RoleAuthority> roleAuthorities = new ArrayList<>();
            if(authorities!=null){
                authorities.forEach(authority->{
                    RoleAuthority roleAuthority = new RoleAuthority(null,role.getId(),authority.getId());
                    roleAuthorities.add(roleAuthority);
                });
            }

            roleAuthorityDao.saveAll(roleAuthorities);
        }
    }

    @GetMapping("/test2/{id}")
    public JobLeads addAuthority(@PathVariable String id) throws Exception{
        JobLeads jobLeads = userService.findJobLeads(id);
        return jobLeads;
    }


}
