package com.zjty.tynotes.weekly.task;

import com.zjty.tynotes.job.status.entity.Personnel;
import com.zjty.tynotes.job.status.service.InternalService;
import com.zjty.tynotes.pas.dao.PasUserDao;
import com.zjty.tynotes.pas.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author gwj
 * @create 2020/3/9 11:19
 */
@Service
public class UserStatus {
    @Autowired
    private PasUserDao pasUserDao;
    @Autowired
    private InternalService internalService;

    @Scheduled(cron = "0/30 * * * * ? ")
    public void setStatus(){
        List<User> users = pasUserDao.findAll();
        List<String> userIds = new ArrayList<>();
        for (User user : users) {
            userIds.add(user.getId());
        }
        List<Personnel> personnels = internalService.personnels(userIds);
        for (User user : users) {
            for (Personnel personnel : personnels) {
                if(user.getId().equals(personnel.getId())){
                    user.setWorkNum(personnel.getCount());
                    if(user.getWorkNum()==0){
                        user.setStatus("0");//用户状态为空闲
                    }else if(user.getWorkNum()<=2&&user.getWorkNum()>0){
                        user.setStatus("1");//用户状态为正常
                    }else{
                        user.setStatus("2");//用户状态为忙碌
                    }
                }
            }
        }
        pasUserDao.saveAll(users);
    }
}
