package com.zjty.tynotes.attendance.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zjty.tynotes.pas.entity.User;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;
import java.util.List;

/**
 * @Author gwj
 * @create 2020/4/13 10:37
 * @des 加班申请类
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "加班申请信息", description = "加班申请信息")
@Document(collection = "workover_appro")
public class WorkoverAppro {
    @Id
    @ApiModelProperty(value = "id",example = "1")
    private String id;

    @ApiModelProperty(value = "加班申请人编号",example = "1")
    private String userId;

    @ApiModelProperty(value = "加班的任务名",example = "1")
    private String name;

    @ApiModelProperty(value = "加班组员名单",example = "1")
    private List<User> groupMenbers;

    @ApiModelProperty(value = "部门id",example = "1")
    private String departmentId;

    @ApiModelProperty(value = "加班起始时间",example = "1")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date date;

    @ApiModelProperty(value = "描述，加班事由",example = "1")
    private String description;

    @ApiModelProperty(value = "审批状态,0代表待审批，1代表已通过，2代表已拒绝",example = "1")
    private String status;

    @ApiModelProperty(value = "审批人id",example = "1")
    private String auditId;

    @ApiModelProperty(value = "申请时间",example = "2020-04-03 09:00:00")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyTime;

}
