package com.zjty.tynotes.job.status.service;

import com.zjty.tynotes.job.basic.entity.database.Work;

public interface TestService {

    /**
     * 新增任务接口
     * 分解任务等
     * @param executorId 操作人id
     * @param latestNews 最近一次操作
     * @param work 任务对象
     */
    void saveTakePushWork(String executorId, String latestNews,  Work work);



    /**
     * 把未发布的任务转变为进行中
     * @param executorId 操作人id
     * @param latestNews 最近一次操作
     * @param work 任务对象
     */
    void unpublishedToOngoing(String executorId, String latestNews,  Work work);
    /**
     * 保存任务
     * @param executorId 操作人id
     * @param latestNews 最近一次操作
     * @param work
     */
    void saveWork(String executorId, String latestNews, Work work);


    /**
     * 修改任务 通用
     * @param executorId 操作人id
     * @param latestNews  最近一次操作
     * @param work 任务对象
     */
    void upDateWork(String executorId, String latestNews, Work work);

    /**
     *
     */
   void appraisal(String executorId, String latestNews,  Work work,int count);
    /**
     * 修改任务状态
     * @param executorId  操作人id
     * @param latestNews 任务对象
     * @param status 任务状态
     * @param work  任务对象
     */

    void updateWorkStatus(String executorId, String latestNews, String status, Work work);


    /**
     * 查看事件的时候
     * @param id 人员id
     * @param eventId 事件id
     * @param readState 是否阅读过  判读是否阅读过  否修改 阅读状态
     */
    void readsStatus(String id, String eventId, int readState);

    /**
     * 人员登入　第一次的数据　接口触发
     * @param id 人员ｉｄ
     */
    void loginFirstOneManualPush(String id);
}
