package com.zjty.tynotes.pas.config.handler;

import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.stereotype.Component;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;

/**
 * @Author: mcj
 * @Date: 19-5-31 下午2:10
 * @Version 1.0
 */
@Component
public class MyLogoutHandler implements LogoutSuccessHandler {

    @Override
    public void onLogoutSuccess(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Authentication authentication) throws IOException, ServletException {
        httpServletResponse.setStatus(200);
        httpServletResponse.setCharacterEncoding("utf-8");
        Enumeration<String> headerNames = httpServletRequest.getHeaderNames();
        httpServletResponse.setContentType("application/json");
        try {
            httpServletResponse.getWriter().println("{\"code\":200,\"msg\":\"用户登出成功\"}");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
