/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.embedded.websocket.frame.rfc6455;

import com.taobao.api.internal.toplink.embedded.websocket.frame.rfc6455.FrameBuilderRfc6455;
import com.taobao.api.internal.toplink.embedded.websocket.frame.rfc6455.FrameHeaderRfc6455;
import com.taobao.api.internal.toplink.embedded.websocket.frame.rfc6455.FrameRfc6455;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class CloseFrame
extends FrameRfc6455 {
    protected CloseFrame(FrameHeaderRfc6455 header, byte[] bodyData) {
        super(header, bodyData);
    }

    public CloseFrame() {
        FrameHeaderRfc6455 header = FrameBuilderRfc6455.createFrameHeader(null, false, FrameBuilderRfc6455.Opcode.CONNECTION_CLOSE);
        this.setHeader(header);
    }

    public CloseFrame(int statusCode, String reasonText) {
        byte[] reasonBytes;
        try {
            reasonBytes = reasonText.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        byte[] body = new byte[reasonBytes.length + 2];
        ByteBuffer buffer = ByteBuffer.wrap(body);
        buffer.putShort((short)statusCode);
        buffer.put(reasonBytes);
        this.setHeader(FrameBuilderRfc6455.createFrameHeader(body, false, FrameBuilderRfc6455.Opcode.CONNECTION_CLOSE));
        this.setContents(body);
    }

    public int getStatusCode() {
        return this.contents.length < 2 ? 0 : (int)ByteBuffer.wrap(this.contents).getShort();
    }

    public String getReasonText() {
        try {
            return this.contents.length <= 2 ? null : new String(this.contents, 2, this.contents.length - 2, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

