package com.zjty.tynotes.pas.dao;

import com.zjty.tynotes.pas.entity.Role;
import org.springframework.data.mongodb.repository.MongoRepository;

import java.util.List;

/**
 * @Author: mcj
 * @Date: 19-4-29 下午2:17
 * @Version 1.0
 */
public interface RoleDao extends MongoRepository<Role, String> {
    List<Role> findAllByIdIn(List<String> ids);

    List<Role> findAllByDepartmentIdAndIsLeader(String departmentIds,String isLeader);

    List<Role> findAllByDepartmentIdAndIsLeaderAndIsPlus(String departmentIds,String isLeader,String plus);

    List<Role> findAllByDepartmentId(String departmentId);

    Role findAllByName(String name);

    void deleteByName(String name);

    Role findByName(String name);

    /**
     * 查询在该角色id内，以及根据角色是否为领导查询角色集合
     * @param ids
     * @param isLeader
     * @return
     */
    List<Role> findAllByIdInAndIsLeader(List<String> ids,String isLeader);

}
