package com.zjty.tynotes.address.server.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;
import java.util.List;

/**
 * @Author gwj
 * @create 2020/5/13 15:18
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "通知信息", description = "通知信息")
@Document(collection = "work_notice")
public class Notice {
    @Id
    @ApiModelProperty(value = "通知信息id",example = "123qdsdd212")
    private String id;

    @ApiModelProperty(value = "通知绑定的任务id",example = "123qdsdd212")
    private String workId;

    @ApiModelProperty(value = "通知绑定的任务名称",example = "123qdsdd212")
    private String workName;

    @ApiModelProperty(value = "请求人的id",example = "123qdsdd212")
    private String applyId;

    @ApiModelProperty(value = "请求人的名字",example = "123qdsdd212")
    private String applyName;

    @ApiModelProperty(value = "反馈人的id",example = "123qdsdd212")
    private String responseId;

    @ApiModelProperty(value = "反馈人的名字",example = "123qdsdd212")
    private String responseName;

    @ApiModelProperty(value = "通知是否同意0同意1拒绝",example = "0")
    private String isAgree;

    @ApiModelProperty(value = "若拒绝，填写拒绝原因",example = "正有其他任务")
    private String reason;

    @ApiModelProperty(value = "部门id",example = "123qdsdd212")
    private String departId;

    @ApiModelProperty(value = "通知是否已读，0未读1已读",example = "0")
    private String isRead;

    @ApiModelProperty(value = "描述",example = "0")
    private String des;

    @ApiModelProperty(value = "所借人的id",example = "0")
    private String borrowUserId;

    @ApiModelProperty(value = "描述",example = "0")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

}
