package com.zjty.tynotes.address.server.service;

import com.zjty.tynotes.address.server.entity.Notice;
import com.zjty.tynotes.pas.entity.Department;
import com.zjty.tynotes.pas.entity.User;

import java.util.List;
import java.util.Map;

/**
 * @Author gwj
 * @create 2020/5/13 14:40
 */
public interface NoticeService {
    /**
     * 查询同级别人员
     * @param level
     * @return
     */
    List<User> findUser(String level);

    /**
     * 提交通知
     * @return
     */
    List<Notice> submitNotice(String publishId,Map<String,List<String>> map,String workId,String workName);

    /**
     * 回应通知
     * @param notice
     * @return
     */
    Notice replyNotice(Notice notice);

    /**
     * 获取某部门下的所有用户(包括同级)
     * @return
     */
    List<User> findUnderUser(String departId);

    /**
     * 查询所有未读通知
     */
    List<Notice> findNotReadNotice(String id);

    /**
     * 查询所有通知
     * @param id
     * @return
     */
    List<Notice> findReadNotice(String id);

    /**
     * 查看发布者下的所有人员id集合
     */
    List<String> findUserIdList(String userId);

    /**
     * 查找发布者的部门等级
     * @param publisher
     * @return
     */
    String findDepartLevel(String publisher);

    /**
     * 查询同级别部门
     * @param level
     * @return
     */
    List<Department> findDepart(String level);

    /**
     * 查找所借人的id集合
     * @param users
     * @param otherIds
     * @return
     */
    Map<String,List<String>> findLeadUser(List<User> users, List<String> otherIds,String level);
}
