package com.zjty.tynotes.attendance.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.zjty.tynotes.attendance.entity.exl.DepartmentExl;
import com.zjty.tynotes.attendance.entity.vo.UserAttenVo;
import com.zjty.tynotes.attendance.entity.vo.request.AttenRequest;
import com.zjty.tynotes.attendance.service.AttendanceDetailsService;
import com.zjty.tynotes.misc.config.AutoDocument;
import com.zjty.tynotes.misc.utils.ExcelUtil;
import com.zjty.tynotes.pas.base.advise.Content;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Api(tags = "考勤模块", protocols = "http")
@RestController
@AutoDocument
@RequestMapping("/attendance")
@Slf4j
public class ExlController {
    @Autowired
    private AttendanceDetailsService attendanceDetailsService;

    @Content(value = "导出元数据excel表格")
    @PostMapping("/excel")
    @ApiOperation(value = "导出元数据excel表格")
    public void exportCurrentPage(HttpServletRequest request, HttpServletResponse response,@RequestBody AttenRequest attenRequest) {
        log.info("元数据 正在执行单页excel导出任务...");
        //把要导出的信息放在map里面
        List<Map<String, Object>> excelList = new ArrayList<>();
        //构建创建导出excel表格所需要的Workbook对象的map
        //源数据
        List<DepartmentExl> departmentExls = attendanceDetailsService.findDepartment(attenRequest).stream().map(UserAttenVo::convert).collect(Collectors.toList());
        Map<String, Object> map = new HashMap<>(8);
        String FpName=attenRequest.getStartDate()+"-"+attenRequest.getEndDate();
        map.put("subFpName", FpName);
        map.put("title", new ExportParams(FpName,FpName));
        map.put("entity", DepartmentExl.class);
        map.put("data",departmentExls);
        excelList.add(map);

        Workbook workbook = ExcelExportUtil.exportExcel(excelList, ExcelType.HSSF);

        ExcelUtil.downloadExcel(request, response, workbook, FpName);

    }
}
