package com.zjty.tynotes.log.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;

/**
 * @Author gwj
 * @create 2020/4/23 9:25
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "日志", description = "日志说明")
@Document(collection = "pas_log")
public class Log {
    @Id
    @ApiModelProperty(value = "id",example = "1")
    private String id;

    @ApiModelProperty(value = "日志描述",example = "进行登录")
    private String description;

    @ApiModelProperty(value = "生成日志时间",example = "2020-03-21 09:00:00")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date logTime;

    @ApiModelProperty(value = "用户id",example = "123")
    private String userId;

    @ApiModelProperty(value = "用户名",example = "gwj")
    private String userName;
}
