package com.zjty.tynotes.weekly.subject.service;

import com.zjty.tynotes.pas.entity.Department;
import com.zjty.tynotes.pas.entity.User;
import com.zjty.tynotes.pas.entity.vo.PageRequest;
import com.zjty.tynotes.pas.entity.vo.PageResponse;

import java.util.List;

/**
 * @Author gwj
 * @create 2020/3/2 13:07
 */
public interface UserManageService {
    /**
     * 根据id查询用户
     * @param id
     * @return
     */
    User findUserById(String id);

    /**
     * 分页查询管理用户
     * @param pageRequest
     * @return
     */
    PageResponse<User> findUserList(PageRequest pageRequest);

    /**
     * 根据用户id查询可管理的部门列表
     * @param id
     * @return
     */
    List<Department> findDepartmentList(String id);

    /**
     * 根据任务状态查询人员任务列表
     * @param id
     * @param status
     * @return
     */
    List<Work> findUserWork(String id, String status);
}
