package com.zjty.tynotes.job.status.controller;

import com.zjty.tynotes.job.status.entity.ActionHistory;
import com.zjty.tynotes.job.status.service.ActionHistoryService;
import com.zjty.tynotes.misc.config.AutoDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author LJJ cnljj1995@gmail.com
 * on 2019-05-13
 */
@RestController
@AutoDocument
@Api(tags = "查看操作历史记录", value = "查看历史操作记录")
public class ActionHistoryController {

    @Autowired
    private ActionHistoryService actionHistoryService;

    @GetMapping("/history")
    @ApiOperation(value = "事件操作历史")
    @ApiImplicitParams(
            @ApiImplicitParam(name = "id", value = "事件id", dataType = "String",
                    example = "5cd92cb738693323e8ee3ba9", required = true)
    )
    public ResponseEntity<List<ActionHistory>> getActionHistory(@RequestParam(value = "id") String id) {
        return ResponseEntity.ok(actionHistoryService.findHistory(id));
    }

}
