package com.zjty.tynotes.job.basic.controller;

import com.zjty.tynotes.job.basic.entity.database.ScoreCoefficient;
import com.zjty.tynotes.job.basic.entity.response.JobResponse;
import com.zjty.tynotes.job.basic.service.ScoreCoefficientService;
import com.zjty.tynotes.job.common.Action;
import com.zjty.tynotes.job.status.service.BusinessTreeManagement;
import com.zjty.tynotes.misc.config.AutoDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Date;

import static org.springframework.http.ResponseEntity.ok;

/**
 * <p>Description : ty-note-backend
 * <p>Date : 2019/5/5 10:08
 * <p>@author : C
 */
@AutoDocument
@Api(tags = "工作记录相关接口", description = "工作记录模块")
@RestController
@RequestMapping("/job/sc")
public class ScController {

    private final
    ScoreCoefficientService scoreCoefficientService;

    @Autowired
    BusinessTreeManagement businessTreeManagement;
    @Autowired
    public ScController(ScoreCoefficientService scoreCoefficientService) {
        this.scoreCoefficientService = scoreCoefficientService;
    }

    @PostMapping("/")
    @ApiOperation(value = "新增考评信息.", notes = "新增不可在数据中附带id.成功时返回新增数据保存的id.")
    public ResponseEntity<JobResponse> add(@RequestBody ScoreCoefficient scoreCoefficient,
                                           @RequestParam String userId) {
        String saveId = scoreCoefficientService.add(scoreCoefficient);
        businessTreeManagement.saveAction(userId,scoreCoefficient.getWordId(),Action.APPRAISAL_WORD,new Date(),"");
        return ok(new JobResponse(saveId));
    }

    @PutMapping("/upDate")
    @ApiOperation(value = "考评信息修改.", notes = "修改必须在数据中附带id.")
    public ResponseEntity<JobResponse> modify(@RequestBody ScoreCoefficient scoreCoefficient,
                                              @RequestParam String userId) {
        String saveId = scoreCoefficientService.modify(scoreCoefficient);
        businessTreeManagement.saveAction(userId,scoreCoefficient.getWordId(),Action.APPRAISAL_WORD,new Date(),"");
        return ok(new JobResponse(saveId));
    }



}
