package com.zjty.tynotes.job.status.service.impl;

import com.zjty.tynotes.job.status.entity.ActionHistory;
import com.zjty.tynotes.job.status.service.ActionHistoryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author LJJ cnljj1995@gmail.com
 * on 2019-05-13
 */
@Service
@Slf4j
public class ActionHistoryServiceImpl implements ActionHistoryService {

    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public List<ActionHistory> findHistory(String id) {

        Criteria criteria = new Criteria();
        criteria.and("taskId").is(id);

        Query query = new Query(criteria);
        query.with(new Sort(Sort.Direction.DESC, "date"));

        return mongoTemplate.find(query, ActionHistory.class);
    }
}
