package com.zjty.tynotes.pas.entity.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @Author gwj
 * @create 2020/3/2 10:54
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PageResponse<T> implements Serializable {
    private static final long serialVersionUID = 5760097915453738435L;

    /**
     * 每页显示个数
     */
    private int pageSize;
    /**
     * 当前页数
     */
    private int currentPage;
    /**
     * 总页数
     */
    private int totalPage;
    /**
     * 总记录数
     */
    private int totalCount;
    /**
     * 结果列表
     */
    private List<T> rows;


    /**
     * 设置结果 及总页数
     * @param rows 分页之后查询到的结果
     */
    public void build(List<T> rows) {
        this.setRows(rows);
        int count =  this.getTotalCount();

        int divisor = count / this.getPageSize();
        int remainder = count % this.getPageSize();
        //设置总页数， Trash code, confusing.
        this.setTotalPage(remainder == 0 ? (divisor == 0 ? 1 : divisor) : divisor + 1);

        //已在setTotalCount中进行

        int countRecords = this.getTotalCount();
        int totalPages = countRecords % pageSize == 0 ? countRecords / pageSize : (countRecords / pageSize + 1);
        setTotalPage(totalPages);

    }
    public List<T> getRows() {
        return rows;
    }
    public void setRows(List<T> rows) {
        this.rows = rows;
    }

}
