package com.zjty.tynotes.search.config;

import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.IOException;

/**
 * @author LJJ cnljj1995@gmail.com
 * on 2019-05-06
 */
@Component
@Slf4j
public class EsConfiguration {
    @Value("${es.ip}")
    private String esIp;

    public RestHighLevelClient conn () {
        return new RestHighLevelClient(
                RestClient.builder(
                        new HttpHost(esIp, 9200, "http")));
    }

    public boolean close(RestHighLevelClient client) {

        try {
            client.close();
            return true;
        } catch (IOException e) {
            log.error("[es] es client close err,the err msg is : {}",e.getMessage());
            return false;
        }
    }
}
