package com.zjty.tynotes.job.basic.entity.request;

import com.zjty.tynotes.job.basic.entity.database.ScoreCoefficient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "请求新增考评对象", description = "新增考评对象")
public class ScRo {
    /**
     * 编号
     */
    @ApiModelProperty(value = "编号", example = "id")
    private String id;

    /**
     * 任务id
     */
    @ApiModelProperty(value = "任务id", example = "任务id")
    private String workId;

    /**
     * 自评分
     */
    @ApiModelProperty(value = "自评分", example = "score1")
    private String score1;

    /**
     * 组长评分
     */
    @ApiModelProperty(value = "组长评分", example = "groupLeaderScore2")
    private String  groupLeaderScore2;
    /**
     * 总监评分
     */
    @ApiModelProperty(value = "总监评分", example = "directorScore2")
    private String directorScore2;
    /**
     * 副总经理评分
     */
    @ApiModelProperty(value = "副总经理评分", example = "viceScore2")
    private String viceScore3;

    /**
     * 总经理评分
     */
    @ApiModelProperty(value = "正总经理评分", example = "justScore4")
    private String justScore4;
    /**
     *  最终工作量
     */
    @ApiModelProperty(value = "最终工作量", example = "endWorkLoad")
    private Double endWorkLoad;
    @ApiModelProperty(value = "用户id", example = "userId")
    private String userId;

    public ScoreCoefficient toDb(){
        return new ScoreCoefficient(id,workId,score1,groupLeaderScore2,directorScore2,viceScore3,justScore4,endWorkLoad);
    }
}
