package com.zjty.tynotes.log.dao;

import com.zjty.tynotes.log.entity.Log;
import org.springframework.data.mongodb.repository.MongoRepository;

import java.util.Date;
import java.util.List;

/**
 * @Author gwj
 * @create 2020/4/23 9:55
 */
public interface LogDao extends MongoRepository<Log,String> {
    /**
     * 根据日志生成时间查询日志
     * @param date
     * @return
     */
    List<Log> findAllByLogTime(Date date);

    /**
     * 根据日志生成时间的区间段查询日志
     * @param start
     * @param end
     * @return
     */
    List<Log> findAllByLogTimeBetween(Date start,Date end);

}
