package com.zjty.tynotes.log.server.impl;

import com.zjty.tynotes.log.dao.LogDao;
import com.zjty.tynotes.log.entity.Log;
import com.zjty.tynotes.log.entity.vo.LogPageRequest;
import com.zjty.tynotes.log.server.LogService;
import com.zjty.tynotes.pas.dao.PasUserDao;
import com.zjty.tynotes.pas.entity.User;
import com.zjty.tynotes.pas.entity.vo.PageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.validation.constraints.NotEmpty;
import java.util.*;

/**
 * @Author gwj
 * @create 2020/4/23 15:01
 */
@Service
public class LogServiceImpl implements LogService {

    private final static Logger logger = LoggerFactory.getLogger(LogServiceImpl.class);

    @Autowired
    private LogDao logDao;
    @Autowired
    private PasUserDao pasUserDao;

    @Override
    public Log saveLog(Log log) {
        if(log.getUserId()!=null){
            String userId = log.getUserId();
            Optional<User> op = pasUserDao.findById(userId);
            if(op.isPresent()){
                User user = op.get();
                String username = user.getUsername();
                log.setUserName(username);
                log.setDescription(username+"执行"+log.getDescription());
                Log save = logDao.save(log);
                return save;
            }
        }
        logger.error("保存进入log日志失败");
        return null;
    }

    /**
     * 分页查找日志
     * @param pageRequest
     * @return
     */
    @Override
    public PageResponse<Log> findLogs(LogPageRequest pageRequest) {
        PageResponse<Log> pageResponse = new PageResponse();
        List<Log> logList = new ArrayList<>();
        List<Log> logs = new ArrayList<>();
        if(pageRequest.getStartTime()!=null && pageRequest.getEndTime()!=null){
            List<Log> logs1 = logDao.findAllByLogTime(pageRequest.getStartTime());
            List<Log> logs2 = logDao.findAllByLogTimeBetween(pageRequest.getStartTime(), pageRequest.getEndTime());
            List<Log> logs3 = logDao.findAllByLogTime(pageRequest.getEndTime());
            if(logs1!=null){
                logs.addAll(logs1);
            }
            if(logs2!=null){
                logs.addAll(logs2);
            }
            if(logs3!=null){
                logs.addAll(logs3);
            }
        }else{
            List<Log> all = logDao.findAll();
            if(all!=null){
                logs = all;
            }
        }
        Collections.sort(logs, new Comparator<Log>() {
            @Override
            public int compare(Log o1, Log o2) {
                return o2.getLogTime().compareTo(o1.getLogTime());
            }
        });
        pageResponse.setPageSize(pageRequest.getPageSize());
        pageResponse.setCurrentPage(pageRequest.getCurrentPage());
        int currentPage = pageRequest.getCurrentPage();
        int pageSize = pageRequest.getPageSize();
        int start = (currentPage-1)*pageSize;
        int end = start+pageSize;
        int totalPage = 0;
        if((logs.size()/pageSize)==0){
            totalPage = (logs.size())/pageSize;
        }else{
            totalPage = (logs.size())/pageSize + 1;
        }
        if(currentPage>=totalPage){
            logList = logs.subList(start, logs.size());
            pageResponse.setRows(logList);
            pageResponse.setTotalCount(logs.size());
        }else{
            logList = logs.subList(start, end);
            pageResponse.setRows(logList);
            pageResponse.setTotalCount(logs.size());
        }
        return pageResponse;

    }
}
