package com.zjty.tynotes.pas.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.zjty.tynotes.misc.config.AutoDocument;
import com.zjty.tynotes.misc.utils.ExcelUtil;
import com.zjty.tynotes.pas.entity.Department;
import com.zjty.tynotes.pas.entity.User;
import com.zjty.tynotes.pas.entity.vo.ImportUserExcel;
import com.zjty.tynotes.pas.service.IUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author gwj
 * @create 2020/4/24 9:36
 * excel导入视图层
 */
@Api(tags = "用户管理权限管理模块",protocols = "http")
@RestController
@RequestMapping("/pas/excel")
@AutoDocument
public class ExcelController {
    @Autowired
    private IUserService iUserService;

    @ApiOperation(value = "上传excel通讯录")
    @PostMapping("/import")
    public List<ImportUserExcel> upload(@RequestParam("file") MultipartFile multipartFile) throws Exception {
        ImportParams params = new ImportParams();
        params.setHeadRows(2);
        params.setNeedVerfiy(true);
        // params.setTitleRows(0);
        List<ImportUserExcel> result = ExcelImportUtil.importExcel(multipartFile.getInputStream(),
                ImportUserExcel.class, params);
        System.out.println(result);
        return result;
    }

    @ApiOperation(value = "导出所有人的excel通讯录")
    @PostMapping("/export")
    public void export(HttpServletRequest request, HttpServletResponse response) throws Exception {
        //把要导出的信息放在map里面
        List<Map<String, Object>> excelList = new ArrayList<>();
        //构建创建导出excel表格所需要的Workbook对象的map
        //源数据
        List<User> users = iUserService.findAll();
        List<ImportUserExcel> importUserExcels = new ArrayList<>();
        if(users!=null){
            users.forEach(user -> {
                importUserExcels.add(new ImportUserExcel(user));
            });

        }
        Map<String, Object> map = new HashMap<>(8);
        String FpName="用户通讯录";
        map.put("subFpName", FpName);
        map.put("title", new ExportParams(FpName,FpName));
        map.put("entity", ImportUserExcel.class);
        map.put("data",importUserExcels);
        excelList.add(map);

        Workbook workbook = ExcelExportUtil.exportExcel(excelList, ExcelType.HSSF);

        ExcelUtil.downloadExcel(request, response, workbook, FpName);
    }

}
