package com.zjty.tynotes.pas.service.impl;

import com.zjty.tynotes.pas.dao.ConfigDao;
import com.zjty.tynotes.pas.dao.DayDao;
import com.zjty.tynotes.pas.entity.Config;
import com.zjty.tynotes.pas.entity.Day;
import com.zjty.tynotes.pas.entity.vo.HolidayRequest;
import com.zjty.tynotes.pas.service.ConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.validation.constraints.NotEmpty;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * @Author gwj
 * @create 2020/3/1 9:46
 */
@Service
public class ConfigServiceImpl implements ConfigService {
    @Autowired
    private ConfigDao configDao;
    @Autowired
    private DayDao dayDao;

    @Override
    public Config save(Config configs) {
        return configDao.save(configs);
    }

    @Override
    public List<Date> findHolidays(HolidayRequest holidayRequest) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        List<Day> days = dayDao.findAllByStatusAndDateBetween("1",
                holidayRequest.getStartDate(), holidayRequest.getEndDate());
        List<Date> dates = new ArrayList<>();
        for (Day day : days) {
            String format = sdf.format(day.getDate());
            try {
                Date parse = sdf.parse(format);
                dates.add(parse);
            } catch (ParseException e) {

            }

        }
        return dates;
    }

    @Override
    public List<Day> setHolidays(List<Day> days) {
        Day day = days.get(0);
        Date date1 = day.getDate();
        int year = date1.getYear();
        int month = date1.getMonth();
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR,year);
        calendar.set(Calendar.MONTH,month);
        calendar.set(Calendar.DAY_OF_MONTH,1);
        Date firstDate = calendar.getTime();
        calendar.set(Calendar.DAY_OF_MONTH,-1);
        Date lastDate = calendar.getTime();
        return dayDao.saveAll(days);
    }

    @Override
    public Day setHoliday(Day day) {
        return dayDao.save(day);
    }

    @Override
    public List<Day> findHolidaysByMonth(String date) {
        List<Day> dayList = new ArrayList<>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Calendar calendar = Calendar.getInstance();
            Date parse = sdf.parse(date);
            calendar.setTime(parse);
            calendar.set(Calendar.DAY_OF_MONTH,1);
            Date startTime = calendar.getTime();
            System.out.println(startTime);
            calendar.add(Calendar.MONTH,1);
            calendar.set(Calendar.DAY_OF_MONTH,0);
            Date endTime = calendar.getTime();
            List<Day> days = dayDao.findAllByDateBetween(startTime, endTime);
            List<Day> days1 = new ArrayList<>();
            calendar.set(Calendar.DAY_OF_MONTH,1);
            if(days==null || days.size()==0){
                int count = calendar.getActualMaximum(Calendar.DAY_OF_MONTH);
                for (int j = 1; j <= count ; j++) {
                    Day day = new Day();
                    day.setStatus("0");
                    day.setDate(calendar.getTime());
                    days1.add(day);
                    calendar.add(Calendar.DATE,1);
                }
                List<Day> days2 = dayDao.saveAll(days1);
                dayList = days2;
            }else{
                Day startDay = dayDao.findByDateEquals(startTime);
                System.out.println(startDay);
                Day endDay = dayDao.findByDateEquals(endTime);
                dayList.add(startDay);
                dayList.addAll(days);
                dayList.add(endDay);
            }
//            Date date1 = sdf.parse(date);
//            int year = date1.getYear()+1900;
//            int month = date1.getMonth()+1;
//            Calendar calendar = Calendar.getInstance();
//            calendar.set(Calendar.YEAR,year);
//            calendar.set(Calendar.MONTH,month-1);
//            calendar.set(Calendar.DAY_OF_MONTH,2);
//            Date firstDate = calendar.getTime();
//            calendar.set(Calendar.MONTH,month);
//            calendar.set(Calendar.DAY_OF_MONTH,0);
//            Date lastDate = calendar.getTime();
//            List<Day> days = dayDao.findAllByDateBetween(firstDate, lastDate);
//            if(days==null || days.size()==0){
//
//                calendar.set(Calendar.DAY_OF_MONTH,2);
//                System.out.println(calendar.getTime());
//                List<String> fullDayList = new ArrayList<>(32);
//                int count = calendar.getActualMaximum(Calendar.DAY_OF_MONTH);
//                for (int j = 1; j <= count ; j++) {
//                    fullDayList.add(sdf1.format(calendar.getTime()));
//                    calendar.add(Calendar.DAY_OF_MONTH,1);
//                }
//                List<Day> days1 = new ArrayList<>();
//                for (String string : fullDayList) {
//                    Day day = new Day();
//                    day.setStatus("0");
//                    day.setDate(sdf1.parse(string));
//                    days1.add(day);
//                }
//                return dayDao.saveAll(days1);
//            }
//            calendar.set(Calendar.MONTH,month-1);
//            calendar.set(Calendar.DAY_OF_MONTH,0);
//            firstDate = calendar.getTime();
//            calendar.set(Calendar.MONTH,month);
//            calendar.set(Calendar.DAY_OF_MONTH,1);
//            lastDate = calendar.getTime();
//            return dayDao.findAllByDateBetween(firstDate,lastDate);
            return dayList;
        } catch (ParseException e) {

        }
        return null;
    }

    @Override
    public Config findConfig() {
        List<Config> all = configDao.findAll();
        if(all!=null&&all.size()!=0){
            return all.get(0);
        }
        return null;
    }

    @Override
    public boolean deleteAll() {
        dayDao.deleteAll();
        return true;
    }


}
