package com.zjty.tynotes.attendance.controller;

import com.zjty.tynotes.attendance.entity.ApprovalInformation;
import com.zjty.tynotes.attendance.entity.vo.UserAttenList;
import com.zjty.tynotes.attendance.entity.vo.UserOverWorkVo;
import com.zjty.tynotes.attendance.entity.vo.request.AttenRequest;
import com.zjty.tynotes.attendance.service.AttendanceDetailsService;
import com.zjty.tynotes.misc.config.AutoDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

import static org.springframework.http.ResponseEntity.ok;

/**
 * @Author gwj
 * @create 2020/3/25 9:12
 * @des 考勤信息统计
 */
@Api(tags = "考勤模块", protocols = "http")
@RestController
@AutoDocument
@RequestMapping("/attendance/info")
public class AttendanceController {
    @Autowired
    private AttendanceDetailsService attendanceDetailsService;


    @ApiOperation(value = "查询个人考勤信息", response = ApprovalInformation.class)
    @PostMapping("/personnel")
    public ResponseEntity personnel(@RequestBody AttenRequest request){
        return ok(attendanceDetailsService.findPersonnel(request));
    }

    @ApiOperation(value = "查询部门考勤信息", response = ApprovalInformation.class)
    @PostMapping("/department")
    public ResponseEntity department(@RequestBody AttenRequest request){
        return ok(attendanceDetailsService.findDepartment(request));
    }

    @ApiOperation(value = "查询某人的考勤列表(请假、调休等等)", response = ApprovalInformation.class)
    @PostMapping("/findAttenList/{type}")
    public ResponseEntity findAttenList(@RequestBody AttenRequest request,@PathVariable String type){
        UserAttenList userAttenList = attendanceDetailsService.findAttenList(request,type);
        return ok(userAttenList);
    }

//    @ApiOperation(value = "查询加班时长", response = ApprovalInformation.class)
//    @PostMapping("/findOverWork/{type}")
//    public ResponseEntity findAttenList(@RequestBody AttenRequest request,@PathVariable String type){
//        UserAttenList userAttenList = attendanceDetailsService.findAttenList(request,type);
//        return ok(userAttenList);
//    }


    @ApiOperation(value = "查询个人加班时长", response = ApprovalInformation.class)
    @GetMapping("/findOverWork/{userId}")
    public ResponseEntity findOverWork(@PathVariable String userId){
        UserOverWorkVo userOverWorkVo = attendanceDetailsService.findOverWork(userId);
        return ok(userOverWorkVo);
    }

    @ApiOperation(value = "清空加班时长", response = ApprovalInformation.class)
    @GetMapping("/clearUserWork")
    public ResponseEntity clearUserWork(){
        try {
            attendanceDetailsService.clearUserWork();
            return ok("清空加班时长成功");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ok("清空加班时长失败");
    }

    @ApiOperation(value = "查询所有人加班时长", response = ApprovalInformation.class)
    @GetMapping("/findAllOverWork/{userId}")
    public ResponseEntity findAllOverWork(@PathVariable String userId){
        List<UserOverWorkVo> userOverWorkVos = attendanceDetailsService.findAllOverWork(userId);
        return ok(userOverWorkVos);
    }

    @ApiOperation(value = "手动增加个人加班时长", response = ApprovalInformation.class)
    @GetMapping("/addOverWork/{userId}/{hour}")
    public ResponseEntity addOverWork(@PathVariable String userId,@PathVariable Long hour){
        UserOverWorkVo userOverWorkVo = attendanceDetailsService.addOverWork(userId,hour);
        if(userOverWorkVo!=null){
            return ok(userOverWorkVo);
        }else{
            return ok("增加个人加班时长失败");
        }

    }

}
