package com.zjty.tynotes.pas.controller;

import com.zjty.tynotes.misc.config.AutoDocument;
import com.zjty.tynotes.pas.base.advise.Content;
import com.zjty.tynotes.pas.entity.Authority;
import com.zjty.tynotes.pas.entity.Config;
import com.zjty.tynotes.pas.entity.Day;
import com.zjty.tynotes.pas.entity.vo.HolidayRequest;
import com.zjty.tynotes.pas.service.ConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;

import static org.springframework.http.ResponseEntity.ok;

/**
 * @Author gwj
 * @create 2020/3/1 9:34
 */
@Api(tags = "用户管理权限管理模块",protocols = "http")
@RestController
@RequestMapping("/pas/config")
@AutoDocument
public class ConfigController {

    @Autowired
    private ConfigService configService;

    @Content(value = "保存基础参数配置")
    @ApiOperation("保存基础参数配置")
    @PostMapping("/addConfig")
    public ResponseEntity addConfig(@RequestBody Config config){
        return ok(configService.save(config));
    }


    @ApiOperation("查询基础参数配置")
    @GetMapping("/findConfig")
    public ResponseEntity findConfig(){
        return ok(configService.findConfig());
    }

    @ApiOperation("获取节假日集合")
    @GetMapping("/getHoliday")
    public ResponseEntity getHoliday(@RequestBody HolidayRequest holidayRequest){
        return ok(configService.findHolidays(holidayRequest));
    }

    @Content(value = "批量设置工作日,节假日")
    @ApiOperation("批量设置工作日,节假日")
    @PutMapping("/setHolidays")
    public ResponseEntity setHolidays(@RequestBody List<Day> days){
        return ok(configService.setHolidays(days));
    }

    @ApiOperation("设置节假日,工作日")
    @PutMapping("/setHoliday")
    public ResponseEntity setHoliday(@RequestBody Day day){
        return ok(configService.setHoliday(day));
    }

    @ApiOperation("获取当月节假日情况")
    @GetMapping("/getHolidayByMonth")
    public ResponseEntity getHolidayByMonth(String date){
        return ok(configService.findHolidaysByMonth(date));
    }

    @Content(value = "清除所有节假日数据")
    @ApiOperation("清除所有节假日数据")
    @DeleteMapping("/deleteAll")
    public ResponseEntity deleteAll(){return ok(configService.deleteAll());}

}
